/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.candlelight.block.entity.TypeWriterEntity;
import net.satisfy.candlelight.client.gui.NoteGui;
import net.satisfy.candlelight.networking.CandlelightMessages;

@OnlyIn(value=Dist.CLIENT)
public class TypeWriterGui
extends NoteGui {
    private final TypeWriterEntity typeWriterEntity;

    public TypeWriterGui(Player player, TypeWriterEntity typeWriterEntity) {
        super(player, typeWriterEntity.getPaper());
        this.typeWriterEntity = typeWriterEntity;
    }

    @Override
    public boolean m_5534_(char chr, int modifiers) {
        boolean result = super.m_5534_(chr, modifiers);
        if (result) {
            this.playTypingSound();
        }
        return result;
    }

    @Override
    protected void finalizeNote(boolean signNote) {
        if (this.dirty) {
            this.removeEmptyPages();
            this.writeNbtData(signNote);
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(this.itemStack.m_41783_());
        buf.m_130064_(this.typeWriterEntity.m_58899_());
        buf.writeBoolean(signNote);
        NetworkManager.sendToServer((ResourceLocation)CandlelightMessages.TYPEWRITER_SYNC, (FriendlyByteBuf)buf);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean result = super.m_7933_(keyCode, scanCode, modifiers);
        if (result && keyCode == 257) {
            this.playEnterSound();
        } else if (result) {
            this.playTypingSound();
        }
        return result;
    }

    private void playEnterSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12210_, (float)1.0f));
    }

    private void playTypingSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)DoApiSoundEventRegistry.TYPEWRITER.get()), (float)1.2f));
    }
}

